-- Sample RDF Data for the 'nature2' Model --
---------------------------------------------------------------------------------------------------------------------------
-- Notes:
-- the 'nature2' model must be created before loading this data
-- also, the nature table must exist before loading this data
-- two different constructors are used to load the RDF data:
-- 1. SDO_RDF_TRIPLE_S(model_name, subject, property, object)
-- 2. SDO_RDF_TRIPLE_S(model_name, sub_or_bn, property, obj_or_bn, bn_m_id)
-- the second constructor allows blank nodes to be reused, when the same blank-node name appears in
-- incoming statements; this constructor is used to load collections: Seq, Bag, and Alt.
-- for data input: URIs are enclosed in <> and literals in ""; blank nodes begin with _:
-- the <> and "" are optional, but recommended.
---------------------------------------------------------------------------------------------------------------------------

INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://www.nature.com/cgi-taf/dynapage.taf?file=/nature/journal/v428/n6978/index.html>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/channel>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://www.nature.com/cgi-taf/dynapage.taf?file=/nature/journal/v428/n6978/index.html>', '<http://purl.org/rss/1.0/title>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://www.nature.com/cgi-taf/dynapage.taf?file=/nature/journal/v428/n6978/index.html>', '<http://purl.org/rss/1.0/description>', '"International weekly journal of science"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://www.nature.com/cgi-taf/dynapage.taf?file=/nature/journal/v428/n6978/index.html>', '<http://purl.org/rss/1.0/link>', '<http://www.nature.com/cgi-taf/dynapage.taf?file=/nature/journal/v428/n6978/index.html>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://www.nature.com/cgi-taf/dynapage.taf?file=/nature/journal/v428/n6978/index.html>', '<http://purl.org/dc/elements/1.1/publisher>', '"Nature Publishing Group"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://www.nature.com/cgi-taf/dynapage.taf?file=/nature/journal/v428/n6978/index.html>', '<http://purl.org/dc/elements/1.1/language>', '"en-GB"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://www.nature.com/cgi-taf/dynapage.taf?file=/nature/journal/v428/n6978/index.html>', '<http://purl.org/dc/elements/1.1/rights>', '"Copyright (C) 2003 Nature Publishing Group"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://www.nature.com/cgi-taf/dynapage.taf?file=/nature/journal/v428/n6978/index.html>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://www.nature.com/cgi-taf/dynapage.taf?file=/nature/journal/v428/n6978/index.html>', '<http://prismstandard.org/namespaces/1.2/basic/issn>', '"0028-0836"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://www.nature.com/cgi-taf/dynapage.taf?file=/nature/journal/v428/n6978/index.html>', '<http://prismstandard.org/namespaces/1.2/basic/publisher>', '"Nature Publishing Group"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://www.nature.com/cgi-taf/dynapage.taf?file=/nature/journal/v428/n6978/index.html>', '<http://prismstandard.org/namespaces/1.2/basic/copyright>', '"Copyright (C) 2003 Nature Publishing Group"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://www.nature.com/cgi-taf/dynapage.taf?file=/nature/journal/v428/n6978/index.html>', '<http://prismstandard.org/namespaces/1.2/basic/rightsAgent>', '"permissions@nature.com"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://www.nature.com/cgi-taf/dynapage.taf?file=/nature/journal/v428/n6978/index.html>', '<http://purl.org/rss/1.0/image>', '<http://nurture.nature.com/rss/images/nature_rss_logo.gif>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_1>', '<http://dx.doi.org/10.1038/428001a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_2>', '<http://dx.doi.org/10.1038/428001b>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_3>', '<http://dx.doi.org/10.1038/428003a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_4>', '<http://dx.doi.org/10.1038/428004a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_5>', '<http://dx.doi.org/10.1038/428004b>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_6>', '<http://dx.doi.org/10.1038/428005a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_7>', '<http://dx.doi.org/10.1038/428006a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_8>', '<http://dx.doi.org/10.1038/428006b>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_9>', '<http://dx.doi.org/10.1038/428007a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_10>', '<http://dx.doi.org/10.1038/428007b>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_11>', '<http://dx.doi.org/10.1038/428008a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_12>', '<http://dx.doi.org/10.1038/428012a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_13>', '<http://dx.doi.org/10.1038/428014a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_14>', '<http://dx.doi.org/10.1038/428017a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_15>', '<http://dx.doi.org/10.1038/428017b>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_16>', '<http://dx.doi.org/10.1038/428017c>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_17>', '<http://dx.doi.org/10.1038/428019a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_18>', '<http://dx.doi.org/10.1038/428020a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_19>', '<http://dx.doi.org/10.1038/428020b>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_20>', '<http://dx.doi.org/10.1038/428021a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_21>', '<http://dx.doi.org/10.1038/428023a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_22>', '<http://dx.doi.org/10.1038/428025a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_23>', '<http://dx.doi.org/10.1038/428026a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_24>', '<http://dx.doi.org/10.1038/428027a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_25>', '<http://dx.doi.org/10.1038/428028a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_26>', '<http://dx.doi.org/10.1038/428029a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_27>', '<http://dx.doi.org/10.1038/428031a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_28>', '<http://dx.doi.org/10.1038/428032a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_29>', '<http://dx.doi.org/10.1038/428032b>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_30>', '<http://dx.doi.org/10.1038/428034a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_31>', '<http://dx.doi.org/10.1038/428035a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_32>', '<http://dx.doi.org/10.1038/428036a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_33>', '<http://dx.doi.org/10.1038/nature02340>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_34>', '<http://dx.doi.org/10.1038/nature02375>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_35>', '<http://dx.doi.org/10.1038/nature02387>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_36>', '<http://dx.doi.org/10.1038/nature02348>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_37>', '<http://dx.doi.org/10.1038/nature02378>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_38>', '<http://dx.doi.org/10.1038/nature02357>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_39>', '<http://dx.doi.org/10.1038/nature02333>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_40>', '<http://dx.doi.org/10.1038/nature02344>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_41>', '<http://dx.doi.org/10.1038/nature02345>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_42>', '<http://dx.doi.org/10.1038/nature02350>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_43>', '<http://dx.doi.org/10.1038/nature02313>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_44>', '<http://dx.doi.org/10.1038/nature02366>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_45>', '<http://dx.doi.org/10.1038/nature02363>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_46>', '<http://dx.doi.org/10.1038/nature02355>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_47>', '<http://dx.doi.org/10.1038/nature02328>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_48>', '<http://dx.doi.org/10.1038/nature02352>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_49>', '<http://dx.doi.org/10.1038/nj6978-101a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_50>', '<http://dx.doi.org/10.1038/nj6978-102a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_51>', '<http://dx.doi.org/10.1038/nj6978-104a>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_52>', '<http://dx.doi.org/10.1038/nj6978-104b>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '_:BNSEQN10031', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#_53>', '<http://dx.doi.org/10.1038/nj6978-104c>', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://www.nature.com/cgi-taf/dynapage.taf?file=/nature/journal/v428/n6978/index.html>', '<http://purl.org/rss/1.0/items>', '_:BNSEQN10031', 5));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://nurture.nature.com/rss/images/nature_rss_logo.gif>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/image>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://nurture.nature.com/rss/images/nature_rss_logo.gif>', '<http://purl.org/rss/1.0/title>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://nurture.nature.com/rss/images/nature_rss_logo.gif>', '<http://purl.org/rss/1.0/url>', '<http://nurture.nature.com/rss/images/nature_rss_logo.gif>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://nurture.nature.com/rss/images/nature_rss_logo.gif>', '<http://purl.org/rss/1.0/link>', '<http://www.nature.com/nature/>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001a>', '<http://purl.org/rss/1.0/title>', '"In no one''s best interest"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428001a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001a>', '<http://purl.org/rss/1.0/description>', '"The latest twist in Britain''s ongoing scare about the safety of a widely used vaccine has brought researchers'' conflicts of interest to public attention. Unfortunately, the affair has promoted a simplistic view of this complex issue."'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001a>', '<http://purl.org/dc/elements/1.1/title>', '"In no one''s best interest"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 1 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428001a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#column>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Editorials"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"1"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001b>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001b>', '<http://purl.org/rss/1.0/title>', '"Ending the pain in Spain"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001b>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428001b>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001b>', '<http://purl.org/rss/1.0/description>', '"Whoever wins the Spanish general election must deliver on their vague promises about supporting science."'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001b>', '<http://purl.org/dc/elements/1.1/title>', '"Ending the pain in Spain"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001b>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 1 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001b>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001b>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428001b>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001b>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001b>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001b>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001b>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001b>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#column>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001b>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Editorials"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428001b>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"1"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428003a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428003a>', '<http://purl.org/rss/1.0/title>', '"Doctors battle to contain AIDS epidemic as unrest engulfs Haiti"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428003a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428003a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428003a>', '<http://purl.org/rss/1.0/description>', '"Erika Check, Washington"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428003a>', '<http://purl.org/dc/elements/1.1/title>', '"Doctors battle to contain AIDS epidemic as unrest engulfs Haiti"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428003a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 3 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428003a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428003a>', '<http://purl.org/dc/elements/1.1/creator>', '"Erika Check"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428003a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428003a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428003a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428003a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428003a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428003a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428003a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#newsBulletin>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428003a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"News"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428003a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"3"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004a>', '<http://purl.org/rss/1.0/title>', '"Climate findings let fishermen off the hook"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428004a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004a>', '<http://purl.org/rss/1.0/description>', '"Quirin Schiermeier, London"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004a>', '<http://purl.org/dc/elements/1.1/title>', '"Climate findings let fishermen off the hook"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 4 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004a>', '<http://purl.org/dc/elements/1.1/creator>', '"Quirin Schiermeier"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428004a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#newsBulletin>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"News"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"4"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004b>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004b>', '<http://purl.org/rss/1.0/title>', '"Bush sacks outspoken biologist from ethics council"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004b>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428004b>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004b>', '<http://purl.org/rss/1.0/description>', '"Erika Check, Washington"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004b>', '<http://purl.org/dc/elements/1.1/title>', '"Bush sacks outspoken biologist from ethics council"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004b>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 4 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004b>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004b>', '<http://purl.org/dc/elements/1.1/creator>', '"Erika Check"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004b>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428004b>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004b>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004b>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004b>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004b>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004b>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#newsBulletin>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004b>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"News"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428004b>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"4"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428005a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428005a>', '<http://purl.org/rss/1.0/title>', '"Medical editors urged to accept ethical code"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428005a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428005a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428005a>', '<http://purl.org/rss/1.0/description>', '"Jim Giles, London"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428005a>', '<http://purl.org/dc/elements/1.1/title>', '"Medical editors urged to accept ethical code"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428005a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 5 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428005a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428005a>', '<http://purl.org/dc/elements/1.1/creator>', '"Jim Giles"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428005a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428005a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428005a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428005a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428005a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428005a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428005a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#newsBulletin>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428005a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"News"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428005a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"5"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006a>', '<http://purl.org/rss/1.0/title>', '"US and biologists wary of strict biotech rules"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428006a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006a>', '<http://purl.org/rss/1.0/description>', '"David Cyranoski, Kuala Lumpur"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006a>', '<http://purl.org/dc/elements/1.1/title>', '"US and biologists wary of strict biotech rules"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 6 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006a>', '<http://purl.org/dc/elements/1.1/creator>', '"David Cyranoski"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428006a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#newsBulletin>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"News"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"6"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006b>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006b>', '<http://purl.org/rss/1.0/title>', '"Gene-ecology agreement circles the globe"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006b>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428006b>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006b>', '<http://purl.org/rss/1.0/description>', '"David Cyranoski"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006b>', '<http://purl.org/dc/elements/1.1/title>', '"Gene-ecology agreement circles the globe"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006b>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 6 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006b>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006b>', '<http://purl.org/dc/elements/1.1/creator>', '"David Cyranoski"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006b>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428006b>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006b>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006b>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006b>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006b>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006b>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#newsBulletin>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006b>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"News"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428006b>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"6"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007a>', '<http://purl.org/rss/1.0/title>', '"Ending of shuttle service puts space experiments "at risk""'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428007a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007a>', '<http://purl.org/rss/1.0/description>', '"Declan Butler"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007a>', '<http://purl.org/dc/elements/1.1/title>', '"Ending of shuttle service puts space experiments "at risk""'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 7 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007a>', '<http://purl.org/dc/elements/1.1/creator>', '"Declan Butler"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428007a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#newsBulletin>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"News"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"7"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007b>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007b>', '<http://purl.org/rss/1.0/title>', '"Spanish lawmakers clash over control of stem-cell research"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007b>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428007b>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007b>', '<http://purl.org/rss/1.0/description>', '"Laura Nelson, London"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007b>', '<http://purl.org/dc/elements/1.1/title>', '"Spanish lawmakers clash over control of stem-cell research"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007b>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 7 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007b>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007b>', '<http://purl.org/dc/elements/1.1/creator>', '"Laura Nelson"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007b>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428007b>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007b>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007b>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007b>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007b>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007b>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#newsBulletin>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007b>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"News"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428007b>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"7"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428008a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428008a>', '<http://purl.org/rss/1.0/title>', '"News in Brief"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428008a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428008a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428008a>', '<http://purl.org/dc/elements/1.1/title>', '"News in Brief"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428008a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 8 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428008a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428008a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428008a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428008a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428008a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428008a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428008a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428008a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#newsBulletin>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428008a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"News"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428008a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"8"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428012a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428012a>', '<http://purl.org/rss/1.0/title>', '"Mount Fuji:  A sleeping giant stirs"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428012a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428012a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428012a>', '<http://purl.org/rss/1.0/description>', '"Mount Fuji is a cultural icon and Japan''s most important geological feature. Yet until it began rumbling a few years ago, scientists had almost completely ignored it, says David Cyranoski. Is it preparing to erupt again?"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428012a>', '<http://purl.org/dc/elements/1.1/title>', '"Mount Fuji:  A sleeping giant stirs"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428012a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 12 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428012a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428012a>', '<http://purl.org/dc/elements/1.1/creator>', '"David Cyranoski"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428012a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428012a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428012a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428012a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428012a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428012a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428012a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#feature>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428012a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"News Feature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428012a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"12"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428014a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428014a>', '<http://purl.org/rss/1.0/title>', '"Cell biology:  Just add water"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428014a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428014a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428014a>', '<http://purl.org/rss/1.0/description>', '"Thanks to a sugar found in yeast, it may be possible to provide "freeze-dried" blood cells to treat injured soldiers. The technique could also find applications in the cell-biology lab. Geoff Brumfiel reports."'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428014a>', '<http://purl.org/dc/elements/1.1/title>', '"Cell biology:  Just add water"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428014a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 14 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428014a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428014a>', '<http://purl.org/dc/elements/1.1/creator>', '"Geoff Brumfiel"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428014a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428014a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428014a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428014a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428014a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428014a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428014a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#feature>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428014a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"News Feature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428014a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"14"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017a>', '<http://purl.org/rss/1.0/title>', '"Time to stop blaming communism in Hungary"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428017a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017a>', '<http://purl.org/rss/1.0/description>', '"Gabor Lente"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017a>', '<http://purl.org/dc/elements/1.1/title>', '"Time to stop blaming communism in Hungary"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 17 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017a>', '<http://purl.org/dc/elements/1.1/creator>', '"Gabor Lente"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428017a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#letterToEditor>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Correspondence"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"17"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017b>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017b>', '<http://purl.org/rss/1.0/title>', '"Hungary: basic science needs European support"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017b>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428017b>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017b>', '<http://purl.org/rss/1.0/description>', '"Laszlo Hunyady"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017b>', '<http://purl.org/dc/elements/1.1/title>', '"Hungary: basic science needs European support"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017b>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 17 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017b>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017b>', '<http://purl.org/dc/elements/1.1/creator>', '"Laszlo Hunyady"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017b>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428017b>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017b>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017b>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017b>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017b>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017b>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#letterToEditor>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017b>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Correspondence"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017b>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"17"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017c>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017c>', '<http://purl.org/rss/1.0/title>', '"Let''s hope there''s a good year on the cards"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017c>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428017c>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017c>', '<http://purl.org/rss/1.0/description>', '"Simon Wain-Hobson"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017c>', '<http://purl.org/dc/elements/1.1/title>', '"Let''s hope there''s a good year on the cards"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017c>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 17 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017c>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017c>', '<http://purl.org/dc/elements/1.1/creator>', '"Simon Wain-Hobson"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017c>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428017c>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017c>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017c>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017c>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017c>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017c>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#letterToEditor>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017c>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Correspondence"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428017c>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"17"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428019a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428019a>', '<http://purl.org/rss/1.0/title>', '"Emerging epidemics"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428019a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428019a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428019a>', '<http://purl.org/rss/1.0/description>', '"We have no one but ourselves to blame for the rise of new killer diseases."'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428019a>', '<http://purl.org/dc/elements/1.1/title>', '"Emerging epidemics"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428019a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 19 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428019a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428019a>', '<http://purl.org/dc/elements/1.1/creator>', '"Tony McMichael"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428019a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428019a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428019a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428019a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428019a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428019a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428019a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Review>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428019a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Books and Arts"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428019a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"19"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020a>', '<http://purl.org/rss/1.0/title>', '"Rooting out the wine plague"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428020a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020a>', '<http://purl.org/rss/1.0/description>', '"Jeffrey Granett reviews Phylloxera: How Wine was Saved for the Worldby Christy Campbell"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020a>', '<http://purl.org/dc/elements/1.1/title>', '"Rooting out the wine plague"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 20 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020a>', '<http://purl.org/dc/elements/1.1/creator>', '"Jeffrey Granett"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428020a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Review>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Books and Arts"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"20"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020b>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020b>', '<http://purl.org/rss/1.0/title>', '"Reissued classics"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020b>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428020b>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020b>', '<http://purl.org/rss/1.0/description>', '"no data"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020b>', '<http://purl.org/dc/elements/1.1/title>', '"Reissued classics"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020b>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 20 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020b>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020b>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428020b>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020b>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020b>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020b>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020b>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020b>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Review>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020b>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Books and Arts"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428020b>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"20"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428021a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428021a>', '<http://purl.org/rss/1.0/title>', '"Science in culture: "'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428021a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428021a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428021a>', '<http://purl.org/rss/1.0/description>', '"Roald Hoffmann"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428021a>', '<http://purl.org/dc/elements/1.1/title>', '"Science in culture: "'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428021a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 21 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428021a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428021a>', '<http://purl.org/dc/elements/1.1/creator>', '"Roald Hoffmann"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428021a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428021a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428021a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428021a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428021a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428021a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428021a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Review>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428021a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Books and Arts"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428021a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"21"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428023a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428023a>', '<http://purl.org/rss/1.0/title>', '"The usefulness of parody"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428023a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428023a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428023a>', '<http://purl.org/rss/1.0/description>', '"A timely rescue from a "too clever" idea."'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428023a>', '<http://purl.org/dc/elements/1.1/title>', '"The usefulness of parody"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428023a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 23 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428023a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428023a>', '<http://purl.org/dc/elements/1.1/creator>', '"John Cairns"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428023a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428023a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428023a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428023a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428023a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428023a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428023a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Review>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428023a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Essay"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428023a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"23"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428025a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428025a>', '<http://purl.org/rss/1.0/title>', '"Microbiology:  Reconstructing the wild types"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428025a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428025a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428025a>', '<http://purl.org/rss/1.0/description>', '"A challenging way to characterize the world''s naturally occurring microbes is to piece together whole genomes from complex communities. An unusually acidic microbial habitat provides the setting for a ranging shot on that target."'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428025a>', '<http://purl.org/dc/elements/1.1/title>', '"Microbiology:  Reconstructing the wild types"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428025a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 25 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428025a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428025a>', '<http://purl.org/dc/elements/1.1/creator>', '"Edward F. Delong"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428025a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428025a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428025a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428025a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428025a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428025a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428025a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Review>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428025a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"News and Views"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428025a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"25"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428026a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428026a>', '<http://purl.org/rss/1.0/title>', '"Superconductivity:  Turn up the temperature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428026a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428026a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428026a>', '<http://purl.org/rss/1.0/description>', '"A more elaborate picture is developing of what makes some materials superconduct at relatively high temperatures. With it come hints for how to design materials with still higher transition temperatures."'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428026a>', '<http://purl.org/dc/elements/1.1/title>', '"Superconductivity:  Turn up the temperature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428026a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 26 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428026a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428026a>', '<http://purl.org/dc/elements/1.1/creator>', '"Piers Coleman"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428026a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428026a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428026a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428026a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428026a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428026a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428026a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Review>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428026a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"News and Views"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428026a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"26"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428027a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428027a>', '<http://purl.org/rss/1.0/title>', '"Ecology:  Chalk-hill blues"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428027a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428027a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428027a>', '<http://purl.org/dc/elements/1.1/title>', '"Ecology:  Chalk-hill blues"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428027a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 27 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428027a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428027a>', '<http://purl.org/dc/elements/1.1/creator>', '"Katrin Bussell"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428027a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428027a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428027a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428027a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428027a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428027a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428027a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Review>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428027a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"News and Views"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428027a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"27"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428028a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428028a>', '<http://purl.org/rss/1.0/title>', '"Cell biology:  A cellular choreographer"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428028a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428028a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428028a>', '<http://purl.org/rss/1.0/description>', '"Specialized cells that form barriers such as those of the intestine adopt a distinct asymmetry. One particular protein may be a prime mover in bringing about such cellular organization."'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428028a>', '<http://purl.org/dc/elements/1.1/title>', '"Cell biology:  A cellular choreographer"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428028a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 28 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428028a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428028a>', '<http://purl.org/dc/elements/1.1/creator>', '"W. James Nelson"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428028a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428028a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428028a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428028a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428028a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428028a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428028a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Review>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428028a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"News and Views"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428028a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"28"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428029a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428029a>', '<http://purl.org/rss/1.0/title>', '"Molecular biology:  Case of mistaken identity"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428029a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428029a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428029a>', '<http://purl.org/rss/1.0/description>', '"An enzyme involved at grass-roots level in assembling genes for receptors that are essential in fighting infection has now been fingered as a suspect in certain cancers - proof that mistakes can be costly."'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428029a>', '<http://purl.org/dc/elements/1.1/title>', '"Molecular biology:  Case of mistaken identity"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428029a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 29 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428029a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428029a>', '<http://purl.org/dc/elements/1.1/creator>', '"Craig H. Bassing"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428029a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428029a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428029a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428029a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428029a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428029a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428029a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Review>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428029a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"News and Views"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428029a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"29"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428031a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428031a>', '<http://purl.org/rss/1.0/title>', '"Palaeoclimate:  Cool stratification"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428031a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428031a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428031a>', '<http://purl.org/rss/1.0/description>', '"The quirky relationship between seawater temperature and density is invoked to account for how, during past global cooling, the high-latitude oceans locked up atmospheric CO2 and produced further cooling."'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428031a>', '<http://purl.org/dc/elements/1.1/title>', '"Palaeoclimate:  Cool stratification"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428031a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 31 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428031a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428031a>', '<http://purl.org/dc/elements/1.1/creator>', '"Roger Francois"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428031a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428031a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428031a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428031a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428031a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428031a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428031a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Review>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428031a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"News and Views"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428031a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"31"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032a>', '<http://purl.org/rss/1.0/title>', '"100 and 50 years ago"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428032a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032a>', '<http://purl.org/dc/elements/1.1/title>', '"100 and 50 years ago"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 32 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428032a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Review>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"News and Views"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"32"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032b>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032b>', '<http://purl.org/rss/1.0/title>', '"Cell division:  Feeling tense enough?"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032b>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428032b>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032b>', '<http://purl.org/rss/1.0/description>', '"Accurately distributing half of each replicated chromosome to both daughters is a major challenge for dividing cells. The mechanisms used to achieve this are becoming apparent, thanks to studies old and new."'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032b>', '<http://purl.org/dc/elements/1.1/title>', '"Cell division:  Feeling tense enough?"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032b>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 32 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032b>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032b>', '<http://purl.org/dc/elements/1.1/creator>', '"Iain M. Cheeseman"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032b>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428032b>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032b>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032b>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032b>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032b>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032b>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Review>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032b>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"News and Views"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428032b>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"32"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428034a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428034a>', '<http://purl.org/rss/1.0/title>', '"News and Views in Brief"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428034a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428034a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428034a>', '<http://purl.org/dc/elements/1.1/title>', '"News and Views in Brief"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428034a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 34 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428034a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428034a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428034a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428034a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428034a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428034a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428034a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428034a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Review>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428034a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"News and Views"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428034a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"34"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428035a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428035a>', '<http://purl.org/rss/1.0/title>', '"Ant parasite queens revert to mating singly"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428035a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428035a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428035a>', '<http://purl.org/rss/1.0/description>', '"Seirian Sumner, William O. H. Hughes, Jes S. Pedersen and Jacobus J. Boomsma"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428035a>', '<http://purl.org/dc/elements/1.1/title>', '"Ant parasite queens revert to mating singly"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428035a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 35 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428035a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428035a>', '<http://purl.org/dc/elements/1.1/creator>', '"Seirian Sumner"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428035a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428035a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428035a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428035a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428035a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428035a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428035a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Analysis>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428035a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Brief Communications"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428035a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"35"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428036a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428036a>', '<http://purl.org/rss/1.0/title>', '"Arctic Ocean (communication arising):  Hydrothermal activity on Gakkel Ridge"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428036a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/428036a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428036a>', '<http://purl.org/rss/1.0/description>', '"Philippe Jean-Baptiste and Elise Fourre"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428036a>', '<http://purl.org/dc/elements/1.1/title>', '"Arctic Ocean (communication arising):  Hydrothermal activity on Gakkel Ridge"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428036a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 36 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428036a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428036a>', '<http://purl.org/dc/elements/1.1/creator>', '"Philippe Jean-Baptiste"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428036a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/428036a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428036a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428036a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428036a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428036a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428036a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Analysis>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428036a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Brief Communications"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/428036a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"36"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02340>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02340>', '<http://purl.org/rss/1.0/title>', '"Community structure and metabolism through reconstruction of microbial genomes from the environment"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02340>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/nature02340>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02340>', '<http://purl.org/rss/1.0/description>', '"Gene W. Tyson, Jarrod Chapman, Philip Hugenholtz, Eric E. Allen, Rachna J. Ram, Paul M. Richardson, Victor V. Solovyev, Edward M. Rubin, Daniel S. Rokhsar and Jillian F. Banfield"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02340>', '<http://purl.org/dc/elements/1.1/title>', '"Community structure and metabolism through reconstruction of microbial genomes from the environment"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02340>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 37 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02340>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02340>', '<http://purl.org/dc/elements/1.1/creator>', '"Gene W. Tyson"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02340>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nature02340>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02340>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02340>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02340>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02340>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02340>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Analysis>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02340>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Articles"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02340>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"37"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02375>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02375>', '<http://purl.org/rss/1.0/title>', '"Mice cloned from olfactory sensory neurons"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02375>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/nature02375>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02375>', '<http://purl.org/rss/1.0/description>', '"Kevin Eggan, Kristin Baldwin, Michael Tackett, Joseph Osborne, Joseph Gogos, Andrew Chess, Richard Axel and Rudolf Jaenisch"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02375>', '<http://purl.org/dc/elements/1.1/title>', '"Mice cloned from olfactory sensory neurons"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02375>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 44 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02375>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02375>', '<http://purl.org/dc/elements/1.1/creator>', '"Kevin Eggan"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02375>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nature02375>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02375>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02375>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02375>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02375>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02375>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Analysis>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02375>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Articles"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02375>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"44"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02387>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02387>', '<http://purl.org/rss/1.0/title>', '"Cavity cooling of a single atom"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02387>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/nature02387>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02387>', '<http://purl.org/rss/1.0/description>', '"P. Maunz, T. Puppe, I. Schuster, N. Syassen, P. W. H. Pinkse and G. Rempe"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02387>', '<http://purl.org/dc/elements/1.1/title>', '"Cavity cooling of a single atom"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02387>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 50 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02387>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02387>', '<http://purl.org/dc/elements/1.1/creator>', '"P. Maunz"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02387>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nature02387>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02387>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02387>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02387>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02387>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02387>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Analysis>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02387>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Letters to Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02387>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"50"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02348>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02348>', '<http://purl.org/rss/1.0/title>', '"An explanation for a universality of transition temperatures in families of copper oxide superconductors"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02348>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/nature02348>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02348>', '<http://purl.org/rss/1.0/description>', '"Sudip Chakravarty, Hae-Young Kee and Klaus Volker"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02348>', '<http://purl.org/dc/elements/1.1/title>', '"An explanation for a universality of transition temperatures in families of copper oxide superconductors"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02348>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 53 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02348>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02348>', '<http://purl.org/dc/elements/1.1/creator>', '"Sudip Chakravarty"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02348>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nature02348>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02348>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02348>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02348>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02348>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02348>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Analysis>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02348>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Letters to Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02348>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"53"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02378>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02378>', '<http://purl.org/rss/1.0/title>', '"Crystal symmetry and the reversibility of martensitic transformations"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02378>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/nature02378>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02378>', '<http://purl.org/rss/1.0/description>', '"Kaushik Bhattacharya, Sergio Conti, Giovanni Zanzotto and Johannes Zimmer"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02378>', '<http://purl.org/dc/elements/1.1/title>', '"Crystal symmetry and the reversibility of martensitic transformations"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02378>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 55 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02378>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02378>', '<http://purl.org/dc/elements/1.1/creator>', '"Kaushik Bhattacharya"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02378>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nature02378>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02378>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02378>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02378>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02378>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02378>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Analysis>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02378>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Letters to Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02378>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"55"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02357>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02357>', '<http://purl.org/rss/1.0/title>', '"Polar ocean stratification in a cold climate"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02357>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/nature02357>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02357>', '<http://purl.org/rss/1.0/description>', '"Daniel M. Sigman, Samuel L. Jaccard and Gerald H. Haug"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02357>', '<http://purl.org/dc/elements/1.1/title>', '"Polar ocean stratification in a cold climate"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02357>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 59 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02357>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02357>', '<http://purl.org/dc/elements/1.1/creator>', '"Daniel M. Sigman"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02357>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nature02357>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02357>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02357>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02357>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02357>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02357>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Analysis>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02357>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Letters to Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02357>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"59"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02333>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02333>', '<http://purl.org/rss/1.0/title>', '"Hybrid fracture and the transition from extension fracture to shear fracture"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02333>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/nature02333>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02333>', '<http://purl.org/rss/1.0/description>', '"Jonathan M. Ramsey and Frederick M. Chester"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02333>', '<http://purl.org/dc/elements/1.1/title>', '"Hybrid fracture and the transition from extension fracture to shear fracture"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02333>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 63 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02333>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02333>', '<http://purl.org/dc/elements/1.1/creator>', '"Jonathan M. Ramsey"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02333>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nature02333>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02333>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02333>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02333>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02333>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02333>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Analysis>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02333>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Letters to Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02333>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"63"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02344>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02344>', '<http://purl.org/rss/1.0/title>', '"Coral mucus functions as an energy carrier and particle trap in the reef ecosystem"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02344>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/nature02344>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02344>', '<http://purl.org/rss/1.0/description>', '"Christian Wild, Markus Huettel, Anke Klueter, Stephan G. Kremb, Mohammed Y. M. Rasheed and Bo B. Jorgensen"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02344>', '<http://purl.org/dc/elements/1.1/title>', '"Coral mucus functions as an energy carrier and particle trap in the reef ecosystem"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02344>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 66 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02344>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02344>', '<http://purl.org/dc/elements/1.1/creator>', '"Christian Wild"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02344>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nature02344>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02344>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02344>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02344>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02344>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02344>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Analysis>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02344>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Letters to Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02344>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"66"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02345>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02345>', '<http://purl.org/rss/1.0/title>', '"Optimal traffic organization in ants under crowded conditions"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02345>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/nature02345>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02345>', '<http://purl.org/rss/1.0/description>', '"Audrey Dussutour, Vincent Fourcassie, Dirk Helbing and Jean-Louis Deneubourg"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02345>', '<http://purl.org/dc/elements/1.1/title>', '"Optimal traffic organization in ants under crowded conditions"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02345>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 70 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02345>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02345>', '<http://purl.org/dc/elements/1.1/creator>', '"Audrey Dussutour"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02345>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nature02345>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02345>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02345>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02345>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02345>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02345>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Analysis>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02345>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Letters to Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02345>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"70"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02350>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02350>', '<http://purl.org/rss/1.0/title>', '"Perceiving distance accurately by a directional process of integrating ground information"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02350>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/nature02350>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02350>', '<http://purl.org/rss/1.0/description>', '"Bing Wu, Teng Leng Ooi and Zijiang J. He"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02350>', '<http://purl.org/dc/elements/1.1/title>', '"Perceiving distance accurately by a directional process of integrating ground information"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02350>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 73 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02350>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02350>', '<http://purl.org/dc/elements/1.1/creator>', '"Bing Wu"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02350>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nature02350>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02350>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02350>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02350>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02350>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02350>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Analysis>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02350>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Letters to Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02350>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"73"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02313>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02313>', '<http://purl.org/rss/1.0/title>', '"Inactivation of hCDC4 can cause chromosomal instability"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02313>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/nature02313>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02313>', '<http://purl.org/rss/1.0/description>', '"Harith Rajagopalan, Prasad V. Jallepalli, Carlo Rago, Victor E. Velculescu, Kenneth W. Kinzler, Bert Vogelstein and Christoph Lengauer"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02313>', '<http://purl.org/dc/elements/1.1/title>', '"Inactivation of hCDC4 can cause chromosomal instability"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02313>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 77 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02313>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02313>', '<http://purl.org/dc/elements/1.1/creator>', '"Harith Rajagopalan"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02313>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nature02313>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02313>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02313>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02313>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02313>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02313>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Analysis>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02313>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Letters to Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02313>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"77"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02366>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02366>', '<http://purl.org/rss/1.0/title>', '"Spatially restricted microRNA directs leaf polarity through ARGONAUTE1"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02366>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/nature02366>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02366>', '<http://purl.org/rss/1.0/description>', '"Catherine A. Kidner and Robert A. Martienssen"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02366>', '<http://purl.org/dc/elements/1.1/title>', '"Spatially restricted microRNA directs leaf polarity through ARGONAUTE1"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02366>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 81 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02366>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02366>', '<http://purl.org/dc/elements/1.1/creator>', '"Catherine A. Kidner"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02366>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nature02366>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02366>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02366>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02366>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02366>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02366>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Analysis>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02366>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Letters to Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02366>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"81"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02363>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02363>', '<http://purl.org/rss/1.0/title>', '"microRNA-mediated repression of rolled leaf1 specifies maize leaf polarity"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02363>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/nature02363>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02363>', '<http://purl.org/rss/1.0/description>', '"Michelle T. Juarez, Jonathan S. Kui, Julie Thomas, Bradley A. Heller and Marja C. P. Timmermans"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02363>', '<http://purl.org/dc/elements/1.1/title>', '"microRNA-mediated repression of rolled leaf1 specifies maize leaf polarity"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02363>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 84 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02363>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02363>', '<http://purl.org/dc/elements/1.1/creator>', '"Michelle T. Juarez"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02363>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nature02363>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02363>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02363>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02363>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02363>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02363>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Analysis>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02363>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Letters to Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02363>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"84"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02355>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02355>', '<http://purl.org/rss/1.0/title>', '"A non-B-DNA structure at the Bcl-2 major breakpoint region is cleaved by the RAG complex"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02355>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/nature02355>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02355>', '<http://purl.org/rss/1.0/description>', '"Sathees C. Raghavan, Patrick C. Swanson, Xiantuo Wu, Chih-Lin Hsieh and Michael R. Lieber"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02355>', '<http://purl.org/dc/elements/1.1/title>', '"A non-B-DNA structure at the Bcl-2 major breakpoint region is cleaved by the RAG complex"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02355>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 88 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02355>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02355>', '<http://purl.org/dc/elements/1.1/creator>', '"Sathees C. Raghavan"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02355>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nature02355>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02355>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02355>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02355>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02355>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02355>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Analysis>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02355>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Letters to Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02355>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"88"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02328>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02328>', '<http://purl.org/rss/1.0/title>', '"Tension between two kinetochores suffices for their bi-orientation on the mitotic spindle"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02328>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/nature02328>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02328>', '<http://purl.org/rss/1.0/description>', '"Hilary Dewar, Kozo Tanaka, Kim Nasmyth and Tomoyuki U. Tanaka"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02328>', '<http://purl.org/dc/elements/1.1/title>', '"Tension between two kinetochores suffices for their bi-orientation on the mitotic spindle"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02328>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 93 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02328>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02328>', '<http://purl.org/dc/elements/1.1/creator>', '"Hilary Dewar"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02328>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nature02328>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02328>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02328>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02328>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02328>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02328>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Analysis>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02328>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Letters to Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02328>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"93"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02352>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02352>', '<http://purl.org/rss/1.0/title>', '"Preferential cis-syn thymine dimer bypass by DNA polymerase e occurs with biased fidelity"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02352>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/nature02352>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02352>', '<http://purl.org/rss/1.0/description>', '"Scott D. McCulloch, Robert J. Kokoska, Chikahide Masutani, Shigenori Iwai, Fumio Hanaoka and Thomas A. Kunkel"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02352>', '<http://purl.org/dc/elements/1.1/title>', '"Preferential cis-syn thymine dimer bypass by DNA polymerase e occurs with biased fidelity"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02352>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 97 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02352>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02352>', '<http://purl.org/dc/elements/1.1/creator>', '"Scott D. McCulloch"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02352>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nature02352>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02352>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02352>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02352>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02352>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02352>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#Analysis>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02352>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Letters to Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nature02352>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"97"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-101a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-101a>', '<http://purl.org/rss/1.0/title>', '"Grad school confidential"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-101a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/nj6978-101a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-101a>', '<http://purl.org/rss/1.0/description>', '"Paul Smaglik"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-101a>', '<http://purl.org/dc/elements/1.1/title>', '"Grad school confidential"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-101a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 101 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-101a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-101a>', '<http://purl.org/dc/elements/1.1/creator>', '"Paul Smaglik"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-101a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nj6978-101a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-101a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-101a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-101a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-101a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-101a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#column>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-101a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Nature Jobs"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-101a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"101"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-102a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-102a>', '<http://purl.org/rss/1.0/title>', '"Stipend survival"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-102a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/nj6978-102a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-102a>', '<http://purl.org/rss/1.0/description>', '"Graduate-student pay levels mean tight budgets and inventive cost-cutting, but is the five-year pay freeze worth it? Kendall Powell calculates the bottom line."'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-102a>', '<http://purl.org/dc/elements/1.1/title>', '"Stipend survival"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-102a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 102 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-102a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-102a>', '<http://purl.org/dc/elements/1.1/creator>', '"Kendall Powell"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-102a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nj6978-102a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-102a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-102a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-102a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-102a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-102a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#feature>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-102a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Nature Jobs"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-102a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"102"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104a>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104a>', '<http://purl.org/rss/1.0/title>', '"Graduate Journal:  Working for balance"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104a>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/nj6978-104a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104a>', '<http://purl.org/rss/1.0/description>', '"Sidney Omelon"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104a>', '<http://purl.org/dc/elements/1.1/title>', '"Graduate Journal:  Working for balance"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104a>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 104 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104a>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104a>', '<http://purl.org/dc/elements/1.1/creator>', '"Sidney Omelon"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104a>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nj6978-104a>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104a>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104a>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104a>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104a>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#feature>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104a>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Nature Jobs"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104a>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"104"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104b>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104b>', '<http://purl.org/rss/1.0/title>', '"Nuts ^& Bolts"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104b>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/nj6978-104b>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104b>', '<http://purl.org/rss/1.0/description>', '"Deb Koen"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104b>', '<http://purl.org/dc/elements/1.1/title>', '"Nuts ^& Bolts"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104b>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 104 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104b>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104b>', '<http://purl.org/dc/elements/1.1/creator>', '"Deb Koen"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104b>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nj6978-104b>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104b>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104b>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104b>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104b>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104b>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#feature>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104b>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Nature Jobs"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104b>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"104"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104c>', '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>', '<http://purl.org/rss/1.0/item>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104c>', '<http://purl.org/rss/1.0/title>', '"Movers"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104c>', '<http://purl.org/rss/1.0/link>', '<http://dx.doi.org/10.1038/nj6978-104c>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104c>', '<http://purl.org/dc/elements/1.1/title>', '"Movers"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104c>', '<http://purl.org/dc/elements/1.1/source>', '"Nature 428, 104 (2003)"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104c>', '<http://purl.org/dc/elements/1.1/date>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104c>', '<http://purl.org/dc/elements/1.1/identifier>', '<doi:10.1038/nj6978-104c>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104c>', '<http://prismstandard.org/namespaces/1.2/basic/publicationName>', '"Nature"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104c>', '<http://prismstandard.org/namespaces/1.2/basic/publicationDate>', '"2004-03-04"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104c>', '<http://prismstandard.org/namespaces/1.2/basic/volume>', '"428"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104c>', '<http://prismstandard.org/namespaces/1.2/basic/number>', '"6978"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104c>', '<http://prismstandard.org/namespaces/1.2/basic/category>', '<http://prismstandard.org/vocabularies/1.2/category.xml#feature>'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104c>', '<http://prismstandard.org/namespaces/1.2/basic/section>', '"Nature Jobs"'));
INSERT INTO nature VALUES (SDO_RDF_TRIPLE_S('nature2', '<http://dx.doi.org/10.1038/nj6978-104c>', '<http://prismstandard.org/namespaces/1.2/basic/startingPage>', '"104"'));
